/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.inline.clean.TrivialConstructorRemoval;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/ClassPostProcessor;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsClass;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsClass;)V", "getRoot", "()Lorg/jetbrains/kotlin/js/backend/ast/JsClass;", "optimizations", "", "Lkotlin/Function0;", "", "getOptimizations", "()Ljava/util/List;", "apply", "", "js.translator"})
public final class ClassPostProcessor {
    @NotNull
    private final JsClass root;
    @NotNull
    private final List<Function0<Boolean>> optimizations;

    public ClassPostProcessor(@NotNull JsClass root) {
        Intrinsics.checkNotNullParameter(root, "root");
        this.root = root;
        this.optimizations = CollectionsKt.listOf(() -> ClassPostProcessor.optimizations$lambda$0(this));
    }

    @NotNull
    public final JsClass getRoot() {
        return this.root;
    }

    @NotNull
    public final List<Function0<Boolean>> getOptimizations() {
        return this.optimizations;
    }

    public final void apply() {
        boolean hasChanges;
        do {
            hasChanges = false;
            for (Function0<Boolean> opt : this.optimizations) {
                hasChanges |= opt.invoke().booleanValue();
            }
        } while (hasChanges);
    }

    private static final boolean optimizations$lambda$0(ClassPostProcessor this$0) {
        return new TrivialConstructorRemoval(this$0.root).apply();
    }
}

